rule ByteCode_MSIL_Ransomware_Povlsomware : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "POVLSOMWARE"
        description         = "Yara rule that detects Povlsomware ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Povlsomware"
        tc_detection_factor = 5

    strings:

        $setup_attack = {
            7E ?? ?? ?? ?? 25 2D ?? 26 7E ?? ?? ?? ?? FE 06 ?? ?? ?? ?? 73 ?? ?? ?? ?? 25 80 ?? ?? 
            ?? ?? 73 ?? ?? ?? ?? 0A 06 6F ?? ?? ?? ?? 00 7E ?? ?? ?? ?? 28 ?? ?? ?? ?? 0B 07 2C ?? 
            00 7E ?? ?? ?? ?? 28 ?? ?? ?? ?? 8E 69 80 ?? ?? ?? ?? 00 7E ?? ?? ?? ?? 28 ?? ?? ?? ?? 
            0C 16 0D 2B ?? 08 09 9A 13 ?? 00 7E ?? ?? ?? ?? 11 ?? 6F ?? ?? ?? ?? 00 00 09 17 58 0D 
            09 08 8E 69 32 ?? 00 38 ?? ?? ?? ?? 00 7E ?? ?? ?? ?? 25 2D ?? 26 7E ?? ?? ?? ?? FE 06 
            ?? ?? ?? ?? 73 ?? ?? ?? ?? 25 80 ?? ?? ?? ?? 73 ?? ?? ?? ?? 13 ?? 11 ?? 1A 6F ?? ?? ?? 
            ?? 00 11 ?? 6F ?? ?? ?? ?? 00 11 ?? 6F ?? ?? ?? ?? 00 00 7E ?? ?? ?? ?? 6F ?? ?? ?? ?? 
            13 ?? 2B ?? 12 ?? 28 ?? ?? ?? ?? 13 ?? 00 00 11 ?? 28 ?? ?? ?? ?? 00 00 DE ?? 26 00 00 
            DE ?? 00 12 ?? 28 ?? ?? ?? ?? 2D ?? DE ?? 12 ?? FE 16 ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 DC 
            28 ?? ?? ?? ?? 00 00 28 ?? ?? ?? ?? 00 28 ?? ?? ?? ?? 00 2A 
        }

        $find_files = {
            02 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 7E ?? ?? ?? ?? 25 2D ?? 26 7E ?? ?? ?? ?? FE 06 ?? ?? 
            ?? ?? 73 ?? ?? ?? ?? 25 80 ?? ?? ?? ?? 28 ?? ?? ?? ?? 0A 00 06 6F ?? ?? ?? ?? 0C 2B ?? 
            08 6F ?? ?? ?? ?? 0D 00 7E ?? ?? ?? ?? 09 6F ?? ?? ?? ?? 00 00 08 6F ?? ?? ?? ?? 2D ?? 
            DE ?? 08 2C ?? 08 6F ?? ?? ?? ?? 00 DC 02 28 ?? ?? ?? ?? 0B 00 07 13 ?? 16 13 ?? 38 ?? 
            ?? ?? ?? 11 ?? 11 ?? 9A 13 ?? 00 11 ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 2D ?? 11 ?? 72 ?? 
            ?? ?? ?? 6F ?? ?? ?? ?? 2D ?? 11 ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 2D ?? 11 ?? 72 ?? ?? 
            ?? ?? 6F ?? ?? ?? ?? 2D ?? 11 ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 2D ?? 11 ?? 72 ?? ?? ?? 
            ?? 6F ?? ?? ?? ?? 2D ?? 11 ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 2D ?? 11 ?? 72 ?? ?? ?? ?? 
            6F ?? ?? ?? ?? 16 FE 01 2B ?? 16 13 ?? 11 ?? 2C ?? 00 11 ?? 03 28 ?? ?? ?? ?? 00 00 00 
            DE ?? 26 00 00 DE ?? 11 ?? 17 58 13 ?? 11 ?? 11 ?? 8E 69 3F ?? ?? ?? ?? 2A 
        }

        $encrypt_files = {
            00 02 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 0A 06 2C ?? 2B ?? 02 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 
            6F ?? ?? ?? ?? 0B 07 2C ?? 2B ?? 02 28 ?? ?? ?? ?? 00 02 02 72 ?? ?? ?? ?? 28 ?? ?? ?? 
            ?? 28 ?? ?? ?? ?? 00 7E ?? ?? ?? ?? 17 58 80 ?? ?? ?? ?? 7E ?? ?? ?? ?? 02 6F ?? ?? ?? 
            ?? 00 7E ?? ?? ?? ?? 02 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 00 2A 
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $setup_attack
        ) and
        (
            $find_files
        ) and
        (
            $encrypt_files
        )
}